﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using CashierCrisis.Managers;

namespace CashierCrisis.UserInterface
{
    public delegate void WidgetCallback(UIWidget widget);

    public abstract class UI
    {
        private bool _visible = true;
        public bool Visible
        {
            get { return _visible; }
            set { _visible = value; }
        }

        private int _selectedIndex = 0;
        public int SelectedIndex
        {
            get { return _selectedIndex; }
            set { _selectedIndex = value; }
        }

        private List<UIWidget> _widgets = new List<UIWidget>();
        public List<UIWidget> Widgets
        {
            get { return _widgets; }
            set { _widgets = value; }
        }


        public SceneManager SceneManager { get; set; }
        public UIManager UIManager { get; set; }


        public virtual void Update(GameTime gameTime)
        {
            for (int i = 0; i < _widgets.Count; i++)
            {
                if (_widgets[i].Active)
                {
                    
                    _widgets[i].Update(gameTime);
                }
            }

            if (SelectedWidget() != null)
            {
                SelectedWidget().WidgetState = 1;
            }

            for (int i = 0; i < Widgets.Count; i++)
            {
                if (Widgets[i] != SelectedWidget())
                {
                    Widgets[i].WidgetState = 0;
                }
            }

         
        }

        public virtual void Draw(SpriteBatch spriteBatch)
        {
            for (int i = 0; i < _widgets.Count; i++)
            {
                if (_widgets[i].Visible)
                {
                    _widgets[i].Draw(spriteBatch);
                }
            }

        }

        public UI(Game game)
        {
            SceneManager = game.Services.GetService(typeof(SceneManager)) as SceneManager;
            UIManager = game.Services.GetService(typeof(UIManager)) as UIManager;
        }

        public virtual void AddWidget(UIWidget widget)
        {
            if (widget != null)
            {
                _widgets.Add(widget);
                widget.ParentUI = this;
                widget.Callback += WidgetCallback;
            }
        }

        public void NextWidget()
        {
            if (_selectedIndex < _widgets.Count - 1)
            {
               
                _selectedIndex++;
            }
            else
            {
       
                _selectedIndex = 0;
            }
        }

        public void PreviousWidget()
        {
            if (_selectedIndex > 0)
            {
                _selectedIndex--;
            }
            else
            {
                _selectedIndex = _widgets.Count - 1;
            }
        }

        public UIWidget SelectedWidget()
        {
            if (Widgets.Count == 0)
                return null;

            UIWidget selected = _widgets[_selectedIndex];

            if (!selected.Active)
            {
                NextWidget();
                selected = _widgets[_selectedIndex];
            }

            return selected;
        }

        public virtual void WidgetCallback(UIWidget widget)
        {

        }
    }
}
